% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{GKSStat}
\alias{GKSStat}
\title{Compute generalized Kolmogorov-Smirnov test statistics}
\usage{
GKSStat(
  x,
  alpha0 = 1,
  index = NULL,
  indexL = NULL,
  indexU = NULL,
  statName = c("KS", "KS+", "KS-", "BJ", "BJ+", "BJ-", "HC", "HC+", "HC-"),
  pvalue = TRUE
)
}
\arguments{
\item{x}{Numeric, the samples that the test statistics will be based on.}

\item{alpha0}{Numeric, controlling which ordered samples will be used in the
statistics, the default value is \code{1}. see details.}

\item{index}{Integer, controlling which ordered samples will be used in the
statistics, see details.}

\item{indexL}{Integer, controlling which ordered samples will be used in the
statistics, see details.}

\item{indexU}{Integer, controlling which ordered samples will be used in the
statistics, see details.}

\item{statName}{Character, the name of the statistic that will be computed.
The default is "KS".}

\item{pvalue}{Logical, whether to compute the p-value of the statistic.
The default is \code{TRUE}}
}
\value{
a \code{generalKSStat} S3 object
}
\description{
Compute the Kolmogorov-Smirnov, Berk-Jones or the higher criticism statistics
to test whether the data is from an uniform(0,1) distribution.
The function \code{GKSStat} provides an uniform way to computes different
test statistics.
To be consistent with the other statistics, the traditional higher criticism
statistic is named \verb{HC+} and the statistic \code{HCStat} computes the
two-sided higher criticism statistic.
}
\details{
\bold{statistics definitions}

The function compute the test statistics which aggregate the significant signal
from the order statistics of the samples, that is, if \code{T} is a statistic
and \code{X_1},\code{X_2},...,\code{X_n} are the samples, the value of \code{T} is purely
based on the value of \code{X_(1)},\code{X_(2)},...,\code{X_(n)},
where \code{X_(i)} is the ith ascending sorted samples of \code{X1},\code{X2},...,\code{Xn}.
Moreover, the rejection region of the statistic \code{T} can be written as
a set of rejection regions of the ordered samples \code{X_(1)},\code{X_(2)},...,\code{X_(n)}.
In other words, there exist two sequences \code{{l_i}} and \code{{u_i}} for \verb{i=1,...,n}
and the statistic \code{T} is rejected if and only if there exist
one \code{i} such that \code{X_(i) < l_i} or \code{X_(i) > u_i}.

The most well-known statistic which takes this form is the Kolmogorov-Smirnov
statistic. Other statistics like Berk-Jones or the higher criticism also have
similar formulas but define different sets of \code{{l_i}} and \code{{u_i}}.

\bold{alpha0, index, indexL and indexU}

As mentioned previouly, the rejection of a test can be determined by the
sequences of \code{{l_i}} and \code{{u_i}}. Therefore, the parameter \code{alpha0}, \code{index}
\code{indexL} and \code{indexU}. provide a way to control which \code{l_i} and \code{u_i}
will be considered in the test procedure. If no argument is provided, all \code{l_i}s
and \code{u_i}s will be compared with their corresponding sorted sample \code{X_(i)}.
This yields the traditional test statistics. If \code{alpha0} is used, only
the data \verb{X_(1),...X_(k)} will be used in the test where \code{k} is the nearest
integer of \code{alpha0*n}. If \code{index} is provided, only \code{X_(i)} for \code{i} in \code{index}
will be considered in the test. If \code{indexL} and/or \code{indexU} is not \code{NULL},
only \code{l_i} for \code{i} in \code{indexL} and \code{u_i} for \code{i} in \code{indexU} will be used as the
rejection boundary for the test. These can be used to generate an one-sided version
of the test statistic. For example, if \code{indexL} is from \code{1} to the length of \code{x} and
\code{indexU} is \code{NULL}, this will yield a test specifically sensitive to smaller samples.
The test statistics like \verb{KS+}, \verb{HC+} and \verb{BJ+} are implemented by calling
\code{GKSStat(..., indexU = NULL)}, where \code{indexU} is always \code{NULL}.
}
\examples{
## Generate samples
x <- rbeta(10, 1, 2)

## Perform KS test
GKSStat(x = x, statName = "KS")

## Perform one-sided KS test
GKSStat(x = x, statName = "KS+")
GKSStat(x = x, statName = "KS-")

}
