% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_transcript}
\alias{GC_transcript}
\title{Modify Transcript Characteristics within a Chart}
\usage{
GC_transcript(
  GC_chart,
  transcript = NULL,
  type = NULL,
  strand = NULL,
  group = NULL,
  selection = NULL,
  show = TRUE,
  colorScheme = NULL,
  customColors = NULL,
  styleExons = list(),
  styleIntrons = list(),
  styleUTRs = list(),
  itemStyleExons = list(),
  itemStyleIntrons = list(),
  itemStyleUTRs = list(),
  labelOptions = list(),
  ...
)
}
\arguments{
\item{GC_chart}{The chart object to be modified.}

\item{transcript}{Optional column name used for clustering transcript data.
Default is NULL.}

\item{type}{Column name identifying the feature type ("UTR",
"exon"). Default is NULL.}

\item{strand}{Optional column name indicating strand orientation. Acceptable
values include 1, 'forward', 'sense', or '+' to represent the forward
strand, and -1, 0, 'reverse', 'antisense', "complement" or '-' to represent
the reverse strand. Default is NULL, meaning strand information is not
used.}

\item{group}{Optional column name used for transcript grouping to influence
color aesthetics.}

\item{selection}{Numeric or character, the specific transcript to filter
transcripts by.}

\item{show}{Logical, whether to show the transcripts or not.}

\item{colorScheme}{Character or NULL, the name of the color scheme to use.}

\item{customColors}{List or NULL, custom colors to apply to the genes.}

\item{styleExons}{List, styles to apply to exons in the chart.}

\item{styleIntrons}{List, styles to apply to introns in the chart.}

\item{styleUTRs}{List, styles to apply to UTRs in the chart.}

\item{itemStyleExons}{List, a list of styles to apply to individual exons in
the chart.}

\item{itemStyleIntrons}{List, a list of styles to apply to individual introns
in the chart.}

\item{itemStyleUTRs}{List, a list of styles to apply to individual UTRs in the
chart.}

\item{labelOptions}{List, options for styling labels such as font size, color,
and position.}

\item{...}{Additional arguments to be passed to the gene options.}
}
\value{
Returns the modified gene chart object.
}
\description{
This function updates the chart with specific characteristics for transcripts
based on the given parameters. It can show/hide transcripts, apply a color
scheme, assign custom colors, filter by cluster, and accept additional
options.
}
\examples{
transcript_data <- data.frame(
  transcript = c("transcript1", "transcript1", "transcript1", "transcript1",
                 "transcript2", "transcript2", "transcript2"),
  type = c("5_utr", "exon", "exon", "3_utr",
           "5_utr", "exon", "3_utr"),
  start = c(1, 101, 201, 301,
            1, 101, 301),
  end = c(50, 150, 250, 350,
          50, 150, 350),
  strand = rep("forward", 7)
)

# All default transcript settings
GC_chart(
  transcript_data,
  start = "start",
  end = "end",
  height = "200px"
) \%>\%
  GC_transcript(
    transcript = "transcript",
    strand = "strand",
    type = "type",
    group = NULL,
    show = TRUE,
    selection = NULL,
    colorScheme = NULL,
    customColors = NULL,
    styleExons = list(
      show = TRUE,
      strokeWidth = 0,
      cursor = "default",
      marker = "box",
      markerSize = "medium",
      arrowheadWidth = NULL,
      arrowheadHeight = NULL,
      markerHeight = NULL,
      cornerRadius = NULL
      # Any other CSS style
    ),
    styleIntrons = list(
      show = TRUE,
      strokeWidth = 1,
      fill = "none",
      cursor = "default",
      marker = "intron",
      markerSize = "medium",
      arrowheadWidth = NULL,
      arrowheadHeight = NULL,
      markerHeight = NULL,
      cornerRadius = NULL
      # Any other CSS style
    ),
    styleUTRs = list(
      show = TRUE,
      fontSize = "10px",
      fontStyle = "normal",
      fontFamily = "sans-serif",
      cursor = "default",
      color = "black",
      fill = "#FFF",
      strokeWidth = 1,
      marker = "box",
      markerSize = "medium",
      arrowheadWidth = NULL,
      arrowheadHeight = NULL,
      markerHeight = NULL,
      cornerRadius = NULL
      # Any other CSS style
    ),
    labelOptions = list(
      show = TRUE,
      xOffset = 2,
      yOffset = 0,
      fontSize = "12px",
      fontStyle = "normal",
      fontWeight = "normal",
      fontFamily = "sans-serif",
      cursor = "default",
      color = "black"
    ),
    itemStyleExons = list(),
    itemStyleIntrons = list(),
    itemStyleUTRs = list()
  )
# Change the appearance of a specific intron
GC_chart(transcript_data,
         start = "start",
         end = "end",
         height = "200px"
) \%>\%
  GC_transcript(
    transcript = "transcript",
    type = "type",
    selection = 2,
    itemStyleExons = list(list(index = 0, fill = "red")
    )
  )
}
