% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_marker_names.R
\name{make_marker_names}
\alias{make_marker_names}
\title{Make genotypeR compliant marker names from the output of read_in_Master_SNPs_data function}
\usage{
make_marker_names(x)
}
\arguments{
\item{x}{Output of read_in_Master_SNPs_data}
}
\value{
A data frame of GrandMasterSNPs markers with correct marker names
}
\description{
\code{make_marker_names} makes genotypeR compliant names. This
is used for input into SNP assay design software. The output is
also used in \code{Ref_Alt_Table}.
}
\examples{

data(markers)
markers <- make_marker_names(markers)

\dontrun{
##example 
GrandMasterSNPs_markers  <- read_in_Master_SNPs_data("GrandMasterSNPs_output")
marker_names_GrandMasterSNPs_markers <- make_marker_names(GrandMasterSNPs_markers)
If subset of markers needed
use the sequenom output to subset the overall marker set from
GrandMasterSNPs output
seq_test_data <- read_in_sequenom_data("path_to_sequenom_data")
col_seq_data <- colnames(seq_test_data)
col_markers <- test_data_marker_names$marker_names
markerinstudy <- test_data_marker_names[col_markers\%in\%col_seq_data,]
}

}
\keyword{GrandMasterSNPs}
\keyword{associated}
\keyword{compliant}
\keyword{genotypeR}
\keyword{marker}
\keyword{markers}
\keyword{names}
\keyword{the}
\keyword{with}
