% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/linear_outcome_linear_envir_interaction_mle_function.R
\name{linear.mles.lin.envir.interaction}
\alias{linear.mles.lin.envir.interaction}
\title{Function to calculate the standard deviation of y given x for linear models with linear environment interaction}
\usage{
linear.mles.lin.envir.interaction(MAF, beta0, ES_G, ES_E, ES_GE,
  Test.Model, True.Model)
}
\arguments{
\item{MAF}{Minor allele Frequency}

\item{beta0}{baseline value for the outcome}

\item{ES_G}{Genetic Effect size}

\item{ES_E}{Environment Effect size}

\item{ES_GE}{Environment x Genetic interaction Effect size}

\item{Test.Model}{Test Model}

\item{True.Model}{True Model}
}
\value{
The standard deviation of y given x for linear models with linear environment interaction
}
\description{
Returns the standard deviation of y given x for linear models with linear environment interaction
}
\examples{
linear.mles.lin.envir.interaction(MAF = 0.28, ES_G = 0.5, beta0 = -0.28,
	ES_E = 1.6, ES_GE = 1.4, Test.Model = "Dominant", True.Model = "Additive")

}
