% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/power_function_environment_interaction_logistic_mle.R
\name{ll.ge.logistic}
\alias{ll.ge.logistic}
\title{Function to calculate MLE's for logistic models with logistic environment interaction}
\usage{
ll.ge.logistic(t, N = NULL, power = NULL, Alpha, mod)
}
\arguments{
\item{t}{A 2x6 table of the joint probabilities of disease, genotype, and environment. Rows are case vs. control and columns are genotypes.}

\item{N}{Sample size}

\item{power}{Power}

\item{Alpha}{Alpha}

\item{mod}{Test model}
}
\value{
A vector of logistic regression model coefficients.
}
\description{
Finds the maximum likelihood estimates for a given 2x3 table under the specified genetic model.
}
\examples{
t <- rbind(c(0.2870353, 0.07833006, 0.00435167, 0.09946088, 0.029199878, 0.0016222154),
	c(0.3609647, 0.06566994, 0.00364833, 0.06253912, 0.006800122, 0.0003777846))
ll.ge.logistic(t, N = 200, Alpha = 0.05, mod = "Dominant")

}
