% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/power_function_environment_interaction_t_matrix_eqs.R
\name{rec.fun.t}
\alias{rec.fun.t}
\title{Function to Calculate t matrix for logistic outcome with binary environment interaction in recessive model}
\usage{
rec.fun.t(MAF, P_e, OR_E, OR_G, OR_GE, Case.Rate)
}
\arguments{
\item{MAF}{Vector of minor allele frequencies}

\item{P_e}{Vector of proportions of the population with exposure to the environmental effect}

\item{OR_E}{Vector of environmental odds ratios to detect}

\item{OR_G}{Vector of genetic odds ratios to detect}

\item{OR_GE}{Vector of genetic/environmental interaction odds ratios to detect}

\item{Case.Rate}{proportion of cases in the sample (cases/(cases + controls)).}
}
\value{
t matrix for all combinations of environment/outcome
}
\description{
Calculates the t matrix for logistic outcome with binary environment interaction in recessive model
}
\examples{
rec.fun.t(MAF = 0.1, P_e = 0.2, Case.Rate = 0.5,
	OR_G = 1.5, OR_E = 2, OR_GE = 1.8)

}
