% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_gen.R
\name{binarySearch_bin}
\alias{binarySearch_bin}
\title{Finds the index of the bin a number belongs to using binary search.}
\usage{
binarySearch_bin(arr, l, r, x)
}
\arguments{
\item{arr}{A vector of size at least 2.}

\item{l}{An integer between 1 and \code{length(arr)}. Must be smaller than \code{1}.}

\item{r}{An integer between 1 and \code{length(arr)}. Must be larger than \code{l}.}

\item{x}{A number. Must be within the range of [\code{arr[l]}, \code{arr[r]}].}
}
\value{
The index \code{i} such that \code{arr[i] <= x <= arr[i+1]}.
}
\description{
Finds the index of the bin a number belongs to using binary search.
}
\details{
Finds the smallest index \code{i} such that \code{arr[i] <= x <= arr[i+1]}.
}
\examples{
binarySearch_bin(1:10, 1, 10, seq(1, 10, by=0.5))
binarySearch_bin(1:10, 5, 8, seq(5, 8, by=0.5))
}
