% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genscore.R
\name{get_h_hp_adaptive}
\alias{get_h_hp_adaptive}
\title{Generator of adaptive h and hp (derivative of h) functions.}
\usage{
get_h_hp_adaptive(mode, para, percentile)
}
\arguments{
\item{mode}{A string, the corresponding mode (with the suffix \code{"_ada"} removed from the input to \code{get_h_hp()}). Must be one of the modes starting with \code{"min_"} supported by \code{get_h_hp_vector()}.}

\item{para}{Must be provided, but can be \code{NULL}. A number, the first parameter; see \code{get_h_hp()} or \code{get_h_hp_vector()}.}

\item{percentile}{A number, the percentile for column-wise truncation on \code{hx} and \code{hpx}.}
}
\value{
A function that returns a list containing \code{hx=h(x)} (element-wise) and \code{hpx=hp(x)} (element-wise derivative of \eqn{h}) when applied to a matrix \code{x}, with both of the results having the same shape as \code{x}.
}
\description{
Generator of adaptive \code{h} and \code{hp} (derivative of \eqn{h}) functions.
}
\details{
Helper function of \code{get_h_hp()}. Please refer to \code{get_hs_hp()}.
}
\examples{
get_h_hp_adaptive("min_log_pow", 1, 0.4)(matrix(0:49, nrow=10))
get_h_hp_adaptive("min_pow", 2, 0.3)(matrix(0:49, nrow=10))
get_h_hp_adaptive("min_softplus", 2, 0.6)(matrix(seq(0, 0.49, by=0.01), nrow=10))

hx_hpx <- get_h_hp_adaptive("min_log_pow", 1, 0.4)(matrix(0:49, nrow=10))
hx_hpx2 <- get_h_hp("min_log_pow_ada", 1, 0.4)(matrix(0:49, nrow=10))
c(max(abs(hx_hpx$hx - hx_hpx2$hx)), max(abs(hx_hpx$hpx - hx_hpx2$hpx)))
}
