% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.gensvm.grid.R
\name{coef.gensvm.grid}
\alias{coef.gensvm.grid}
\title{Get the parameter grid from a GenSVM Grid object}
\usage{
\method{coef}{gensvm.grid}(object, ...)
}
\arguments{
\item{object}{a \code{gensvm.grid} object}

\item{\dots}{further arguments are ignored}
}
\value{
The parameter grid of the GenSVMGrid object as a data frame.
}
\description{
Returns the parameter grid of a \code{gensvm.grid} object.
}
\examples{
\donttest{
x <- iris[, -5]
y <- iris[, 5]

grid <- gensvm.grid(x, y)
pg <- coef(grid)
}

}
\references{
Van den Burg, G.J.J. and Groenen, P.J.F. (2016). \emph{GenSVM: A Generalized 
Multiclass Support Vector Machine}, Journal of Machine Learning Research, 
17(225):1--42. URL \url{http://jmlr.org/papers/v17/14-526.html}.
}
\seealso{
\code{\link{gensvm.grid}}, \code{\link{gensvm-package}}
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen \cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
