% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{bf1skel}
\alias{bf1skel}
\title{Computation of Bayes factors at the skeleton points}
\usage{
bf1skel(runs, bfsize1 = 0.8, method = c("RL", "MW"), reference = 1)
}
\arguments{
\item{runs}{A list with outputs from the function
\code{\link{mcsglmm}} or \code{\link{mcstrga}}.}

\item{bfsize1}{A scalar or vector of the same length as \code{runs}
with all integer values or all values in (0, 1]. How many samples
(or what proportion of the sample) to use for estimating the Bayes
factors at the first stage. The remaining sample will be used for
estimating the Bayes factors in the second stage. Setting it to 1
will perform only the first stage.}

\item{method}{Which method to use to calculate the Bayes factors:
Reverse logistic or Meng-Wong.}

\item{reference}{Which model goes in the denominator.}
}
\value{
A list with components
\itemize{
\item \code{logbf} A vector containing logarithm of the Bayes factors.
\item \code{logLik1} \code{logLik2} Matrices with the values of
the log-likelihood computed from the samples for each model at the
first and second stages.
}
}
\description{
Function to compute the Bayes factors from MCMC samples.
}
\details{
Computes the bayes factors using \code{method} with respect to
\code{reference}.
}
\references{
Geyer, C. J. (1994). Estimating Normalizing Constants
and Reweighting Mixtures. Technical report, University of
Minnesota.

Meng, X. L., & Wong, W. H. (1996). Simulating Ratios of
Normalizing Constants via a Simple Identity: A Theoretical
Exploration. \emph{Statistica Sinica}, 6, 831-860.
}

