% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bf.R
\name{bf1skel}
\alias{bf1skel}
\title{Computation of Bayes factors at the skeleton points}
\usage{
bf1skel(runs, bfsize1 = 0.8, method = c("RL", "MW"), reference = 1,
  transf = FALSE, binwo = TRUE)
}
\arguments{
\item{runs}{A list with outputs from the function
\code{\link{mcsglmm}} or \code{\link{mcstrga}}.}

\item{bfsize1}{A scalar or vector of the same length as
\code{runs} with all integer values or all values in (0, 1]. How
many samples (or what proportion of the sample) to use for
estimating the Bayes factors at the first stage. The remaining
sample will be used for estimating the Bayes factors in the second
stage. Setting it to 1 will perform only the first stage.}

\item{method}{Which method to use to calculate the Bayes factors:
Reverse logistic or Meng-Wong.}

\item{reference}{Which model goes in the denominator.}

\item{transf}{Whether to use the transformed sample mu for the
computations. Otherwise it uses z.}

\item{binwo}{For the binomial family, if use workaround when the
untransformed sample is used.}
}
\value{
A list with components
\itemize{
\item \code{logbf} A vector containing logarithm of the Bayes factors.
\item \code{logLik1} \code{logLik2} Matrices with the values of
the log-likelihood computed from the samples for each model at the
first and second stages.
\item \code{isweights} A vector with the importance sampling
weights for computing the Bayes factors at new points that will be
used at the second stage. Used internally in
\code{\link{bf2new}} and \code{\link{bf2optim}}.
\item \code{controlvar} A matrix with the control variates
computed at the samples that will be used in the second stage.
\item \code{sample2} The MCMC sample for mu or z that will be
used in the second stage. Used internally in
\code{\link{bf2new}} and \code{\link{bf2optim}}.
\item \code{N1}, \code{N2} Vectors containing the sample sizes
used in the first and second stages.
\item \code{distmat} Matrix of distances between locations.
\item \code{betm0}, \code{betQ0}, \code{ssqdf}, \code{ssqsc},
\code{tsqdf}, \code{tsqsc}, \code{dispersion}, \code{response},
\code{weights}, \code{modelmatrix}, \code{locations},
\code{family}, \code{corrfcn}, \code{transf} Model parameters used
internally in.
\code{\link{bf2new}} and \code{\link{bf2optim}}.
\item \code{pnts} A list containing the skeleton points. Used
internally in \code{\link{bf2new}} and \code{\link{bf2optim}}.
}
}
\description{
Function to compute the Bayes factors from MCMC samples.
}
\details{
Computes the Bayes factors using \code{method} with respect to
\code{reference}.
}
\examples{
\dontrun{
data(rhizoctonia)
### Define the model
corrf <- "spherical"
kappa <- 0
ssqdf <- 1
ssqsc <- 1
betm0 <- 0
betQ0 <- .01
linkp <- "probit"
### Skeleton points
philist <- c(100, 140, 180)
omglist <- c(.5, 1)
parlist <- expand.grid(phi=philist, linkp=linkp, omg=omglist, kappa = kappa)
### MCMC sizes
Nout <- 100
Nthin <- 1
Nbi <- 0
### Take MCMC samples
runs <- list()
for (i in 1:NROW(parlist)) {
  runs[[i]] <- mcsglmm(Infected ~ 1, 'binomial', rhizoctonia, weights = Total,
                       atsample = ~ Xcoord + Ycoord,
                       Nout = Nout, Nthin = Nthin, Nbi = Nbi,
                       betm0 = betm0, betQ0 = betQ0,
                       ssqdf = ssqdf, ssqsc = ssqsc,
                       phistart = parlist$phi[i], omgstart = parlist$omg[i],
                       linkp = parlist$linkp[i], kappa = parlist$kappa[i],
                       corrfcn = corrf, phisc = 0, omgsc = 0)
}
bf <- bf1skel(runs)
bf$logbf
}
}
\references{
Geyer, C. J. (1994). Estimating normalizing constants
and reweighting mixtures. Technical report, University of
Minnesota.

Meng, X. L., & Wong, W. H. (1996). Simulating ratios of
normalizing constants via a simple identity: A theoretical
exploration. \emph{Statistica Sinica}, 6, 831-860.

Roy, V., Evangelou, E., and Zhu, Z. (2015). Efficient estimation
and prediction for the Bayesian spatial generalized linear mixed
model with flexible link functions. \emph{Biometrics}.
\url{http://dx.doi.org/10.1111/biom.12371}
}

