% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\docType{methods}
\name{spc.plot.time}
\alias{spc.plot.time}
\alias{spc.plot.time,Spectra-method}
\title{Plotting \code{Spectra} object}
\usage{
spc.plot.time(object, ...)

\S4method{spc.plot.time}{Spectra}(object, Y, maxSp = 50, xdata = "time",
  lab_cex, lwd = 2, ...)
}
\arguments{
\item{object}{A \code{Spectra} object.}

\item{...}{any further arguments of plot}

\item{Y}{character. Name of the columns of the \code{Spectra} object to be plotted.}

\item{maxSp}{numeric. Maximum number of \code{Spectra} to plot.}

\item{xdata}{character. Type of time-series data. Can be 'time' or 'observations'.}

\item{lab_cex}{vector of character expansion sizes, used cyclically.}

\item{lwd}{vector of line widths}
}
\description{
Generating plot of the contents of a \code{Spectra} object with respect to time.
If xdata is 'time', data is plotted with respect to the 'TIME' column. If xdata 
is 'observations', data is plotted with respect to an integer index equal to 1:nrow(object).
}
\examples{
x <- spc.example_spectra()
spc.plot.time(x)

}
\seealso{
\code{\link{spc.plot.depth}}
}
