% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetervar.R
\name{hetervar}
\alias{hetervar}
\title{Heteroscedastic variance estimation for remotely-sensed data}
\usage{
hetervar(
  x,
  m = NULL,
  lenPeriod = 23,
  method = c("standard", "robust-mad", "robust-Qn")
)
}
\arguments{
\item{x}{numeric vector}

\item{m}{matrix with \code{nrow} equal to the number of periods (seasons 
or years) analyzed and \code{ncol} equal to the number of observations 
per period}

\item{lenPeriod}{numeric giving the number of observations per period.
Default, 23.}

\item{method}{character specifying whether \code{standard} variance,
the median absolute deviation (\code{robust-mad}) or
the more efficient robust variance estimator (\code{robust-Qn}) 
should be used}
}
\value{
A numeric vector of length \code{lenPeriod}
}
\description{
Variance of some remotely-sensed Earth data is time-varying. Utilizing the 
observations per period (season, year), this function allows for estimation
of variability in data either as numeric vector or matricial form
}
\details{
Designed for data extracted from time series of satellite imagery. Then, it is expected that 
\code{length(x)} be a multiple of \code{lenPeriod}. When \code{m} is provided,
\code{ncol(m)} must be equal to \code{lenPeriod}. Default of \code{lenPeriod} corresponds to the 
temporal resolution of some MODIS products.

Method \code{standard} invokes \code{\link[stats]{sd}} whereas \code{robust-mad}
uses the median absolute deviation of \code{\link[stats]{mad}} and \code{robust-Qn}
utilizes the robust scale estimator implemented in \code{\link[robustbase]{Qn}}.

This function does not allow missing values.
}
\seealso{
\code{\link[stats]{sd}}, \code{\link[stats]{mad}}, \code{\link[robustbase]{Qn}}
}
