% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_indigenous_land.R
\name{read_indigenous_land}
\alias{read_indigenous_land}
\title{Download official data of indigenous lands as an sf object.}
\usage{
read_indigenous_land(date, tp = "simplified")
}
\arguments{
\item{date}{A date numer in YYYYMM format.}

\item{tp}{Whether the function returns the 'original' dataset with high resolution or a dataset with 'simplified' borders (Default)}
}
\description{
The data set covers the whole of Brazil and it includes indigenous lands from all ethnicities and
in different stages of demarcation. The original data comes from the National Indian Foundation (FUNAI)
and can be found at http://www.funai.gov.br/index.php/shape. Although original data is updated monthly,
the geobr package will only keep the data for a few months per year.
}
\examples{
\donttest{

library(geobr)

# Read all indigenous land in an specific date
  i <- read_indigenous_land(date=201907)

}

}
