% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{calcqualityIndexes}
\alias{calcqualityIndexes}
\title{Quality indexes}
\usage{
calcqualityIndexes(data, belongmatrix, m)
}
\arguments{
\item{data}{The original dataframe used for the classification (n*p)}

\item{belongmatrix}{A membership matrix (n*k)}

\item{m}{The fuzziness parameter used for the classification}
}
\value{
A named list with
\itemize{
        \item Silhouette.index: the silhouette index (fclust::SIL.F)
        \item Partition.entropy: the partition entropy index (fclust::PE)
        \item Partition.coeff: the partition entropy coefficient (fclust::PC)
        \item Modified.partition.coeff: the modified partition entropy coefficient (fclust::MPC)
        \item XieBeni.index : the Xie and Beni index (fclust::XB)
        \item FukuyamaSugeno.index : the Fukuyama and Sugeno index (geocmeans::calcFukuyamaSugeno)
        \item Explained.inertia: the percentage of total inertia explained by the solution
}
}
\description{
calculate several clustering quality indexes (most of them come from fclust
package)
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
calcqualityIndexes(result$Data,result$Belongings, m=1.5)
}
