% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{spConsistency}
\alias{spConsistency}
\title{Spatial consistency index}
\usage{
spConsistency(belongmatrix, nblistw, nrep = 999)
}
\arguments{
\item{belongmatrix}{A membership matrix}

\item{nblistw}{A list.w object describing the neighbours (spdep package)
observation must get in the membership matrix to not be considered as
uncertain (default = NULL)}

\item{nrep}{An integer indicating the number of permutation to do to simulate}
}
\value{
A named list with
 \itemize{
        \item Mean : the mean of the spatial consistency index
        \item prt05 : the 5th percentile of the spatial consistency index
        \item prt95 : the 95th percentule of the spatial consistency index
        \item samples : all the value of the spatial consistency index
}
}
\description{
Calculate a spatial consistency index
}
\details{
This index is experimental, it aims to measure how much a clustering solution
is spatially consistent. A classification is spatially inconsistent if
neighbouring observation do not belong to the same group. See detail for
a description of its calculation

The total spatial inconsistency (*Scr*) is calculated as follow

\deqn{isp = \sum_{i}\sum_{j}\sum_{k} (u_{ik} - u_{jk})^{2} * W_{ij}}

With U the membership matrix, i an observation, k the neighbours of i and W
the spatial weight matrix This represents the total spatial inconsistency of
the solution (true inconsistency) We propose to compare this total with
simulated values obtained by permutations (simulated inconsistency). The
values obtained by permutation are an approximation of the spatial
inconsistency obtained in a random context Ratios between the true
inconsistency and simulated inconsistencies are calculated A value of 0
depict a situation where all observations are identical to their neighbours
A value of 1 depict a situation where all observations are as much different
as their neighbours that what randomness can produce A classification
solution able to reduce this index has a better spatial consistency
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
spConsistency(result$Belongings, Wqueen, nrep=50)
}
