% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boostrap_clust_validation.R
\name{boot_group_validation.mc}
\alias{boot_group_validation.mc}
\title{Check that the obtained groups are stable by bootstrap (multicore)}
\usage{
boot_group_validation.mc(
  object,
  nsim = 1000,
  maxiter = 1000,
  tol = 0.01,
  init = "random",
  verbose = TRUE,
  seed = NULL
)
}
\arguments{
\item{object}{A FCMres object, typically obtained from functions CMeans,
GCMeans, SFCMeans, SGFCMeans}

\item{nsim}{The number of replications to do for the bootstrap evaluation}

\item{maxiter}{An integer for the maximum number of iterations}

\item{tol}{The tolerance criterion used in the evaluateMatrices function for
convergence assessment}

\item{init}{A string indicating how the initial centres must be selected.
"random" indicates that random observations are used as centres. "kpp" use
a distance based method resulting in more dispersed centres at the
beginning. Both of them are heuristic.}

\item{verbose}{A boolean to specify if the progress bar should be displayed.}

\item{seed}{An integer to control randomness, default is NULL}
}
\value{
A list of two values: group_consistency: a dataframe indicating
  the consistency across simulations each cluster ; group_centres: a list with
  a dataframe for each cluster. The values in the dataframes are the centres
  of the clusters at each simulation.
}
\description{
Check that the obtained groups are stable by bootstrap with
  multicore support
}
\details{
For more details, see the documentation of the function
  boot_group_validation
}
\examples{
\dontrun{
data(LyonIris)

#selecting the columns for the analysis
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14",
                   "Pct_65","Pct_Img","TxChom1564","Pct_brevet","NivVieMed")

#rescaling the columns
Data <- LyonIris@data[AnalysisFields]
for (Col in names(Data)){
  Data[[Col]] <- as.numeric(scale(Data[[Col]]))
}

Cmean <- CMeans(Data,4,1.5,500,standardize = FALSE, seed = 456,
    tol = 0.00001, verbose = FALSE)

future::plan(future::multiprocess(workers=2))

validation <- boot_group_validation.mc(Cmean, nsim = 1000, maxiter = 1000,
    tol = 0.01, init = "random")
## make sure any open connections are closed afterward
if (!inherits(future::plan(), "sequential")) future::plan(future::sequential)
}
}
