% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{uncertaintyMap}
\alias{uncertaintyMap}
\title{Uncertainty map}
\usage{
uncertaintyMap(
  geodata,
  belongmatrix,
  njit = 150,
  radius = NULL,
  colors = NULL,
  pt_size = 0.05
)
}
\arguments{
\item{geodata}{An object of class spatialpolygonesdataframe /
spatiallinesdataframe or spatialpointsdataframe ordered
like the original data used for the clustering.}

\item{belongmatrix}{A membership matrix}

\item{njit}{The number of points to map on each feature.}

\item{radius}{When mapping points, the radius indicates how far random
points will be plotted around the original features.}

\item{colors}{A vector of colors to use for the groups.}

\item{pt_size}{A float giving the size of the random points on the final
map (default is 0.05)}
}
\value{
a map created with ggplot2
}
\description{
Return a map to visualize membership matrix
}
\details{
This function maps the membership matrix by plotting
random points in polygons, along lines or around points representing the
original observations. Each cluster is associated with a color and each
random point has a probability to be of that color equal to the membership
value of the feature it belongs itself. Thus, it is possible to
visualize regions with uncertainty and to identify the strongest clusters.
}
\examples{
\dontrun{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
  "TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
uncertaintyMap(LyonIris, result$Belongings)
}
}
