% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps2dataframe.r
\name{maps2dataframe}
\alias{maps2dataframe}
\title{maps2dataframe}
\usage{
maps2dataframe(y_shp, x_shp_n, namescolomn)
}
\arguments{
\item{y_shp}{The shipfile( polygons or points) containing explained varialble in its attribute table.}

\item{x_shp_n}{Shipfiles( polygons or points) containing explained varialble in their attribute tables.}

\item{namescolomn}{Field names which represent explained variable and explanatory variables, respectively. The order correspond with y_shp and x_shp_n.}
}
\value{
dataframe transformed from shape files.
If input data is shapefile format, the function named geoDetector can be used to transform from shapefile map to table format. Please note that, these shapefile layers should have the same projected coordinate system.
}
\description{
This function transforms the information of varialbles from shipfiles to  dataframe.
}
\examples{
library(maptools)

data(DiseaseData_shp)
data(SoilType_shp)
data(Watershed_shp)
data(Elevation_shp)
CollectData2<-maps2dataframe(DiseaseData_shp,c(SoilType_shp, Watershed_shp,
                             Elevation_shp),namescolomn= c('incidence',
                             'soiltype', 'watershed', 'elevation'))

factor_detector("incidence","soiltype",CollectData2)
factor_detector(1,2,CollectData2)
factor_detector (1,c(2,3,4),CollectData2)
rst <- factor_detector ("incidence",c("soiltype","watershed"),CollectData2)
interaction_detector("incidence",c("soiltype","watershed"),CollectData2)
interaction_detector("incidence",c("soiltype","watershed","elevation"),CollectData2)

risk_detector("incidence","soiltype",CollectData2)
risk_detector(1,2,CollectData2)
risk_detector(1,c(2,3,4),CollectData2)
risk_detector("incidence",c("soiltype"),CollectData2)

ecological_detector("incidence",c("soiltype","watershed"),CollectData2)
ecological_detector("incidence",c("soiltype","watershed","elevation"),CollectData2)
}
\keyword{dataframe.}
\keyword{or}
\keyword{shipfile}
\keyword{table}
\keyword{to}
\keyword{transform}
