% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscb_acs_5ye_get_geo.R
\name{get_available_years_downloaded}
\alias{get_available_years_downloaded}
\alias{get_available_years_downloaded.uscb_acs_5ye}
\title{Get available years downloaded}
\usage{
get_available_years_downloaded(ua, geodatabase, folder = NULL)

\method{get_available_years_downloaded}{uscb_acs_5ye}(ua, geodatabase, folder = NULL)
}
\arguments{
\item{ua}{A \code{uscb_acs_5ye} object.}

\item{geodatabase}{A string.}

\item{folder}{A string.}
}
\value{
A vector of integers.
}
\description{
For the name of a geodatabase, returns a vector with the years for which data
is available on the local folder.
}
\details{
If the folder is not indicated, it is considered that of the class.
}
\examples{

folder <- system.file("extdata", package = "geogenr")
folder <- stringr::str_replace_all(paste(folder, "/", ""), " ", "")
ua <- uscb_acs_5ye(folder = folder)
sa <- ua |> get_statistical_areas()

# sa[6]
# [1] "New England City and Town Area Division"

y <- ua |> get_available_years_downloaded(geodatabase = sa[6])

}
\seealso{
Other data collection functions: 
\code{\link{download_geodatabases}()},
\code{\link{get_available_years_in_the_web}()},
\code{\link{get_legal_and_administrative_areas}()},
\code{\link{get_statistical_areas}()},
\code{\link{uscb_acs_5ye}()}
}
\concept{data collection functions}
