% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topojson_write.R
\name{topojson_write}
\alias{topojson_write}
\title{Write TopoJSON from various inputs}
\usage{
topojson_write(
  input,
  lat = NULL,
  lon = NULL,
  geometry = "point",
  group = NULL,
  file = "myfile.topojson",
  overwrite = TRUE,
  precision = NULL,
  convert_wgs84 = FALSE,
  crs = NULL,
  object_name = "foo",
  quantization = 0,
  ...
)
}
\arguments{
\item{input}{Input list, data.frame, spatial class, or sf class.
Inputs can  also be dplyr \code{tbl_df} class since it inherits
from \code{data.frame}}

\item{lat}{(character) Latitude name. The default is \code{NULL}, and we
attempt to guess.}

\item{lon}{(character) Longitude name. The default is \code{NULL}, and we
attempt to guess.}

\item{geometry}{(character) One of point (Default) or polygon.}

\item{group}{(character) A grouping variable to perform grouping for
polygons - doesn't apply for points}

\item{file}{(character) A path and file name (e.g., myfile), with the
\code{.geojson} file extension. Default writes to current working
directory.}

\item{overwrite}{(logical) Overwrite the file given in \code{file} with
\code{input}. Default: \code{TRUE}. If this param is \code{FALSE} and
the file already exists, we stop with error message.}

\item{precision}{desired number of decimal places for the coordinates in the
geojson file. Using fewer decimal places can decrease file sizes (at the
cost of precision).}

\item{convert_wgs84}{Should the input be converted to the
\href{https://tools.ietf.org/html/rfc7946}{standard CRS for GeoJSON}
(geographic coordinate reference
system, using the WGS84 datum, with longitude and latitude units of decimal
degrees; EPSG: 4326). Default is \code{FALSE} though this may change in a
future package version. This will only work for \code{sf} or \code{Spatial}
objects with a CRS already defined. If one is not defined but you know what
it is, you may define it in the \code{crs} argument below.}

\item{crs}{The CRS of the input if it is not already defined. This can be
an epsg code as a four or five digit integer or a valid proj4 string. This
argument will be ignored if \code{convert_wgs84} is \code{FALSE} or the
object already has a CRS.}

\item{object_name}{(character) name to give to the TopoJSON object created.
Default: "foo"}

\item{quantization}{(numeric) quantization parameter, use this to
quantize geometry prior to computing topology. Typical values are powers of
ten (\code{1e4}, \code{1e5}, ...), default is \code{0} to not perform quantization.
For more information about quantization, see this by Mike Bostock
https://stackoverflow.com/questions/18900022/topojson-quantization-vs-simplification/18921214#18921214}

\item{...}{Further args passed on to internal functions. For Spatial*
classes, data.frames,
regular lists, and numerics, it is passed through to
\code{\link[sf:st_write]{sf::st_write()}}. For sf classes,
geo_lists and json classes, it is passed through to
\code{\link[jsonlite:toJSON]{jsonlite::toJSON()}}.}
}
\value{
A \code{topojson_write} class, with two elements:
\itemize{
\item path: path to the file with the TopoJSON
\item type: type of object the TopoJSON came from, e.g., SpatialPoints
}
}
\description{
\code{topojson_write()} is temporarily defunct; check back later
}
\details{
Under the hood we simply wrap \code{\link[=geojson_write]{geojson_write()}}, then
take the GeoJSON output of that operation, then convert to TopoJSON with
\code{\link[=geo2topo]{geo2topo()}}, then write to disk.

Unfortunately, this process requires a number of round trips to disk, so
speed ups will hopefully come soon.

Any intermediate geojson files are cleaned up (deleted).
}
\seealso{
\code{\link[=geojson_write]{geojson_write()}}, \code{\link[=topojson_read]{topojson_read()}}
}
