% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf_geojson.R
\name{df_geojson}
\alias{df_geojson}
\title{df to GeoJSON}
\usage{
df_geojson(df, lon, lat, z = NULL, m = NULL, atomise = FALSE,
  simplify = TRUE, digits = NULL, factors_as_string = TRUE)
}
\arguments{
\item{df}{data.frame}

\item{lon}{column of \code{df} containing the longitude data}

\item{lat}{column of \code{df} containing the latitude data}

\item{z}{column of \code{df} containing the Z attribute of the GeoJSON}

\item{m}{column of \code{df} containing the M attribute of the GeoJSON.
If supplied, you must also supply \code{z}}

\item{atomise}{logical indicating if the data.frame should be converted into a vector
of GeoJSON objects}

\item{simplify}{logical indicating if data.frame without property columns should simplify
(\code{TRUE}) into a vector of GeoJSON, or (\code{FALSE}). If \code{atomise} is TRUE
this argument is ignored.}

\item{digits}{integer specifying the number of decimal places to round numerics.
numeric values are coorced using \code{as.integer}, which may round-down the value you supply.
Default is \code{NULL} - no rounding}

\item{factors_as_string}{logical indicating if factors should be treated as strings. Defaults to TRUE.}
}
\value{
vector of GeoJSON
}
\description{
Converts data.frame objects to GeoJSON. Each row is considerd a POINT
}
\examples{

df <- data.frame(lon = c(1:5, NA), lat = c(1:5, NA), id = 1:6, val = letters[1:6])
df_geojson( df, lon = "lon", lat = "lat")
df_geojson( df, lon = "lon", lat = "lat", atomise = TRUE)

df <- data.frame(lon = c(1:5, NA), lat = c(1:5, NA) )
df_geojson( df, lon = "lon", lat = "lat")
df_geojson( df, lon = "lon", lat = "lat", simplify = FALSE)

df <- data.frame(lon = c(1:5), lat = c(1:5), elevation = c(1:5) )
df_geojson( df, lon = "lon", lat = "lat", z = "elevation")
df_geojson( df, lon = "lon", lat = "lat", z = "elevation", simplify = FALSE)

df <- data.frame(lon = c(1:5), lat = c(1:5), elevation = c(1:5), id = 1:5 )
df_geojson( df, lon = "lon", lat = "lat", z = "elevation")
df_geojson( df, lon = "lon", lat = "lat", z = "elevation", atomise = TRUE)


## to sf objects
geo <- df_geojson( df, lon = "lon", lat = "lat", z = "elevation")
sf <- geojson_sf( geo )

}
