% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency.R
\name{subtract_edge}
\alias{subtract_edge}
\title{Subtract Edges from an Adjacency List}
\usage{
subtract_edge(adj, v1, v2, zero = TRUE)
}
\arguments{
\item{adj}{list of adjacent precincts}

\item{v1}{integer or integer array for first vertex to connect.
If array, connects each to corresponding entry in v2.}

\item{v2}{integer or integer array for second vertex to connect.
If array, connects each to corresponding entry in v1.}

\item{zero}{boolean, TRUE if \code{adj} is zero indexed. False if one indexed.}
}
\value{
adjacency list.
}
\description{
Subtract Edges from an Adjacency List
}
\examples{
data(towns)
adj <- adjacency(towns)
subtract_edge(adj, 2, 3)

}
\concept{fix}
