% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOResponsibleParty.R
\docType{class}
\name{ISOResponsibleParty}
\alias{ISOResponsibleParty}
\title{ISOResponsibleParty}
\format{\code{\link{R6Class}} object.}
\usage{
ISOResponsibleParty
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO ResponsibleParty
}
\description{
ISOResponsibleParty
}
\section{Fields}{

\describe{
\item{\code{individualName}}{[\code{\link{character}}] Individual name}

\item{\code{organisationName}}{[\code{\link{character}}] Organization name}

\item{\code{positionName}}{[\code{\link{character}}] Position name}

\item{\code{contactInfo}}{[\code{\link{ISOContact}}] contact information}

\item{\code{role}}{[\code{\link{ISORole}}] role}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml,value)}}{
   This method is used to instantiate an ISOResponsibleParty
 }
 \item{\code{setIndividualName(invidualName, locales)}}{
   Set the individual name. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setOrganisationName(organisationName, locales)}}{
   Set the organisation name. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setPositionName(positionName, locales)}}{
   Set the position name. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setContactInfo(contactInfo)}}{
   Set the contact info, should be an object of class \code{\link{ISOContact}}
 }
 \item{\code{setRole(role)}}{
   Set the role, either an object of class "character" (among values
   available in \code{ISORole$values()}) or an object of class \code{\link{ISORole}}.
 }
}
}

\examples{
  #create a responsible party element
  md <- ISOResponsibleParty$new()
  md$setIndividualName("someone")
  md$setOrganisationName("somewhere")
  md$setPositionName("someposition")
  md$setRole("pointOfContact")
  
  #add contact
  contact <- ISOContact$new()
  phone <- ISOTelephone$new()
  phone$setVoice("myphonenumber")
  phone$setFacsimile("myfacsimile")
  contact$setPhone(phone)
  address <- ISOAddress$new()
  address$setDeliveryPoint("theaddress")
  address$setCity("thecity")
  address$setPostalCode("111")
  address$setCountry("France")
  address$setEmail("someone@theorg.org")
  contact$setAddress(address)
  res <- ISOOnlineResource$new()
  res$setLinkage("http://www.somewhereovertheweb.org")
  res$setName("somename")
  contact$setOnlineResource(res)
  md$setContactInfo(contact)
  
  xml <- md$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{file}
\keyword{identifier}
