% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryProcessStepReport.R
\docType{class}
\name{ISOImageryProcessStepReport}
\alias{ISOImageryProcessStepReport}
\title{ISOImageryProcessStepReport}
\format{\code{\link{R6Class}} object.}
\usage{
ISOImageryProcessStepReport
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery ProcessStepReport
}
\description{
ISOImageryProcessStepReport
}
\section{Fields}{

\describe{
\item{\code{name}}{[\code{\link{character}}|\code{\link{ISOLocalisedCharacterString}}]}

\item{\code{description}}{[\code{\link{character}}|\code{\link{ISOLocalisedCharacterString}}]}

\item{\code{fileType}}{[\code{\link{character}}|\code{\link{ISOLocalisedCharacterString}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryProcessStepReport}}
 }
 \item{\code{setName(name, locales)}}{
   Sets a name (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{setDescription(description, locales)}}{
   Sets a description (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{setFileType(fileType, locales)}}{
   Sets a fileType (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
}
}

\examples{
   md <- ISOImageryProcessStepReport$new()
   md$setName("my_report")
   md$setDescription("description")
   md$setFileType("md")
   xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{ProcessStepReport}
\keyword{imagery}
