% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMLEnvelopeWithTimePeriod.R
\docType{class}
\name{GMLEnvelopeWithTimePeriod}
\alias{GMLEnvelopeWithTimePeriod}
\title{GMLEnvelopeWithTimePeriod}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an GML envelope with time period
}
\description{
GMLEnvelopeWithTimePeriod
}
\section{Fields}{

\describe{
\item{\code{beginPosition}}{[\code{\link{GMLElement}}]}

\item{\code{endPosition}}{[\code{\link{GMLElement}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, bbox, beginPosition, endPosition, 
                 srsName, srsDimension, axisLabels, uomLabels)}}{
   This method is used to instantiate a GML envelope with time period. The \code{bbox}
   parameter should be an object of class \code{matrix} with 2 columns giving mix/max
   values of each dimension (handled by row). At least one row is required (1D), and
   can be extended with as many dimensions required. The parameters \code{beginPosition}
   and \code{endPosition} allow to specify the temporal extent of the envelope.
 }
}
}

\references{
ISO 19136:2007 Geographic Information -- Geographic Markup Language.
  http://www.iso.org/iso/iso_catalogue/catalogue_tc/catalogue_detail.htm?csnumber=32554 
  
  OGC Geography Markup Language. http://www.opengeospatial.org/standards/gml
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{EnvelopeWithTimePeriod}
\keyword{GML}
\keyword{ISO}
