% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryPlatformPass.R
\docType{class}
\name{ISOImageryPlatformPass}
\alias{ISOImageryPlatformPass}
\title{ISOImageryPlatformPass}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery PlatformPass
}
\description{
ISOImageryPlatformPass
}
\section{Fields}{

\describe{
\item{\code{identifier}}{[\code{\link{ISOMetaIdentifier}}]}

\item{\code{extent}}{[?]}

\item{\code{relatedEvent}}{[\code{list} of \code{\link{ISOImageryEvent}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryPlatformPass}}
 }
 \item{\code{setIdentifier(identifier)}}{
   Sets an identifier, object of class \code{character} or \code{\link{ISOMetaIdentifier}}
 }
 \item{\code{setExtent(extent)}}{
   Set the extent
 }
 \item{\code{addEvent(event)}}{
   Add a event, object of class \code{\link{ISOImageryEvent}}
 }
 \item{\code{delEvent(event)}}{
   Deletes a event, object of class \code{\link{ISOImageryEvent}}
 }
}
}

\examples{
   md <- ISOImageryPlatformPass$new()
   md$setIdentifier("identifier")
   
   require(sf)
   outer = matrix(c(0,0,10,0,10,10,0,10,0,0),ncol=2, byrow=TRUE)
   hole1 = matrix(c(1,1,1,2,2,2,2,1,1,1),ncol=2, byrow=TRUE)
   hole2 = matrix(c(5,5,5,6,6,6,6,5,5,5),ncol=2, byrow=TRUE)
   pts = list(outer, hole1, hole2)
   pl = st_polygon(pts)
   md$setExtent(pl)
   
   xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{PlatformPass}
\keyword{imagery}
