% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOAbstractObject.R
\docType{class}
\name{ISOAbstractObject}
\alias{ISOAbstractObject}
\title{ISOAbstractObject}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Metadata Element
}
\description{
ISOAbstractObject
}
\note{
Abstract ISO Metadata class used internally by geometa
}
\section{Static Methods}{

\describe{
 \item{\code{getISOStandardByPrefix(prefix)}}{
   Inherit the ISO (and/or OGC) standard reference for a given standard prefix (e.g. GMD).
   The object returned is a \code{data.frame} containing the specification reference
   and title.
 }
 \item{\code{getISOStandard(clazz)}}{
   Inherit the ISO (and/or OGC) standard reference for a given \pkg{geometa} class.
   The object returned is a \code{data.frame} containing the specification reference
   and title.
 }
 \item{\code{getISOClasses(extended, pretty)}}{
   Get the list of classes supported by \pkg{geometa}. By default, \code{extended} is
   set to \code{FALSE} (restrained to \pkg{geometa} environment). If \code{TRUE}, this
   allows to list eventual classes loaded in your global environment and that extend
   \pkg{geometa} classes. The argument \code{pretty} gives a the list of classes and 
   associated ISO/OGC standard information as \code{data.frame}.
 }
 \item{\code{getISOClassByNode(node)}}{
   Inherit the ISO class matching an XML document or node
 }
 \item{\code{compare(metadataElement1, metadataElement2)}}{
   Compares two metadata elements objects. Returns TRUE if they are equal,
   FALSE otherwise. The comparison of object is done by comparing the XML 
   representation of the objects (since no R6 object comparison method seems 
   to exist)
 }
}
}

\section{Abstract Methods}{

\describe{
 \item{\code{new(xml, element, namespace, defaults, attrs)}}{
   This method is used to instantiate an ISOAbstractObject
 }
 \item{\code{print()}}{
   Provides a custom print output (as tree) of the current class
 }
 \item{\code{decode(xml)}}{
   Decodes a ISOMetadata* R6 object from XML representation
 }
 \item{\code{encode(addNS, validate, strict, inspire, inspireValidator, resetSerialID, setSerialID, encoding)}}{
   Encodes a ISOMetadata* R6 object to XML representation. By default, namespace
   definition will be added to XML root (\code{addNS = TRUE}), and validation
   of object will be performed (\code{validate = TRUE}) prior to its XML encoding.
   The argument \code{strict} allows to stop the encoding in case object is not
   valid, with a default value set to \code{FALSE}. The argument \code{setSerialID}
   is used by \pkg{geometa} to generate automatically serial IDs associated to
   XML elements, in particular for GML, default value is \code{TRUE} (recommended value).
   The argument \code{resetSerialID} is used by \pkg{geometa} for reseting mandatory IDs
   associated to XML elements, such as GML objects, default value is \code{TRUE} 
   (recommended value).
   Setting \code{inspire} to TRUE (default FALSE), the metadata will be checked with
   the INSPIRE metadata validator (online web-service provided by INSPIRE). To check 
   metadata with the INSPIRE metadata validator, setting an INSPIRE metadata validator 
   is now required, and should be specified with the \code{inspireValidator}. See 
   \code{\link{INSPIREMetadataValidator}} for more details
 }
 \item{\code{validate(xml, strict, inspire, inspireValidator)}}{
   Validates the encoded XML against ISO 19139 XML schemas. If \code{strict} is
   \code{TRUE}, a error will be raised. Default is \code{FALSE}.
   Setting \code{inspire} to\code{TRUE} (default \code{FALSE}), the metadata will be 
   checked with the INSPIRE metadata validator (online web-service provided by INSPIRE).
   To check metadata with the INSPIRE metadata validator, setting an INSPIRE metadata validator 
   is now required, and should be specified with the \code{inspireValidator}. See 
   \code{\link{INSPIREMetadataValidator}} for more details
 }
 \item{\code{save(file, ...)}}{
   Saves the current metadata object XML representation to a file. This utility
   ensures proper indentation of XML file produced. Additional parameters from 
   \code{$encode()} method can be specified, such as \code{inspire} to check
   the INSPIRE metadata validity.
 }
 \item{\code{getNamespaceDefinition(recursive)}}{
   Gets the namespace definition of the current ISO* class. By default, only
   the namespace definition of the current element is retrieved (\code{recursive = FALSE}).
 }
 \item{\code{getClassName()}}{
   Gets the class name
 }
 \item{\code{getClass()}}{
   Gets the class
 }
 \item{\code{wrapBaseElement(field, fieldObj)}}{
   Wraps a base element type
 }
 \item{\code{setIsNull(isNull, reason)}}{
   Sets the object as null object for the XML. In case \code{isNull} is \code{TRUE},
   a reason should be specified among values 'inapplicable', 'missing', 'template',
   'unknown', 'withheld'. By default, the reason is set 'missing'.
 }
 \item{\code{contains(field, metadataElement)}}{
   Indicates of the present class object contains an metadata element object
   for a particular list-based field.
 }
 \item{\code{addListElement(field, metadataElement)}}{
   Adds a metadata element to a list-based field. Returns TRUE if the element
   has been added, FALSE otherwise. In case an element is already added, the 
   element will not be added and this method will return FALSE.
 }
 \item{\code{delListElement(field, metadataElement)}}{
   Deletes a metadata element from a list-based field. Returns TRUE if the element
   has been deleted, FALSE otherwise. In case an element is abstent, this method 
   will return FALSE.
 }
 \item{\code{setAttr(attrKey, attrValue)}}{
   Set an attribute
 }
 \item{\code{addFieldAttrs(field, ...)}}{
   Allows to add one more xlink attributes a field (element property)
 }
 \item{\code{setId(id, addNS)}}{
   Set an id. By default \code{addNS} is \code{FALSE} (no namespace prefix added).
 }
 \item{\code{setHref(href)}}{
   Sets an href reference
 }
 \item{\code{setCodeList(codeList)}}{
   Sets a codeList
 }
 \item{\code{setCodeListValue(codeListValue)}}{
   Sets a codeList value
 }
 \item{\code{setCodeSpace(codeSpace)}}{
   Set a codeSpace
 }
 \item{\code{setValue(value)}}{
   Set a value
 }
 \item{\code{isDocument()}}{
   Indicates if the object is a metadata document, typically an object of class
   \code{ISOMetadata} or \code{ISOFeatureCatalogue}
 }
 \item{\code{isFieldInheritedFrom(field)}}{
   Gives the parent from which the field is inherited, otherwise return \code{NULL}.
 }
 \item{\code{createLocalisedProperty(text, locales)}}{
   Creates a localised property made of a default text and a list of localised texts.
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{element}
\keyword{metadata}
