% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setCRS.R
\docType{methods}
\name{setCRS}
\alias{setCRS}
\alias{setCRS,ANY-method}
\alias{setCRS,geom-method}
\alias{setCRS,Spatial-method}
\alias{setCRS,sf-method}
\alias{setCRS,Raster-method}
\title{Set (or transform) the coordinate reference system of a spatial object.}
\usage{
setCRS(x, crs, ...)

\S4method{setCRS}{ANY}(x)

\S4method{setCRS}{geom}(x, crs = NULL)

\S4method{setCRS}{Spatial}(x, crs = NULL)

\S4method{setCRS}{sf}(x, crs = NULL)

\S4method{setCRS}{Raster}(x, crs = NULL)
}
\arguments{
\item{x}{the object for which to set the coordinate reference system.}

\item{crs}{[\code{character(1)}]\cr the coordinate reference system to set
for this object.}

\item{...}{other arguments.}
}
\value{
The object \code{x} with an assigned or transformed coordinate
  reference system.
}
\description{
Set (or transform) the coordinate reference system of a spatial object.
}
\details{
In case an object does not yet have a coordinate reference system
  assigned, this function simply assigns it. In case the object has already a
  valid crs, a transformation to the new crs will be carried out. The
  transformation is computed for all classes with the standard defined in the
  \code{rgdal} package.
}
\seealso{
Other setters: 
\code{\link{setFeatures}()},
\code{\link{setGroups}()},
\code{\link{setHistory}()},
\code{\link{setWindow}()}
}
\concept{setters}
