% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal.lop.vs.R
\name{logp.vs}
\alias{logp.vs}
\title{The log-unnormalized posterior probability of a model for Bayesian
variable selection.}
\usage{
logp.vs(model, X, y, lam, w)
}
\arguments{
\item{model}{The indices of active variables.}

\item{X}{The \eqn{n\times p} covariate matrix without intercept.}

\item{y}{The response vector of length \eqn{n}.}

\item{lam}{The slab precision parameter.}

\item{w}{The prior inclusion probability of each variable.}
}
\value{
The log-unnormalized posterior probability of the model.
}
\description{
Calculates the log-unnormalized posterior probability of a model.
}
\examples{
n=50; p=100; nonzero = 3
trueidx <- 1:3
nonzero.value <- 4
TrueBeta <- numeric(p)
TrueBeta[trueidx] <- nonzero.value
rho <- 0.5
xone <- matrix(rnorm(n*p), n, p)
X <- sqrt(1-rho)*xone + sqrt(rho)*rnorm(n)
y <- 0.5 + X \%*\% TrueBeta + rnorm(n)
result <- geomc.vs(X=X, y=y)
logp.vs(result$median.model,X,y,lam = nrow(X)/ncol(X)^2,w = sqrt(nrow(X))/ncol(X))
}
\references{
Roy, V.(2024) A geometric approach to informative MCMC sampling https://arxiv.org/abs/2406.09010
}
\author{
Vivekananda Roy
}
