\name{digit.fixed}
\alias{digit.fixed}
\title{Digitize 3D landmarks}
\usage{
digit.fixed(spec, fixed, index = FALSE, ptsize = 1, center = TRUE)
}
\arguments{
  \item{spec}{An object of class shape3d/mesh3d, or matrix
  of 3D vertex coordinates}

  \item{fixed}{Numeric The number landmarks (fixed, and
  curve sliders if desired)}

  \item{index}{Logical Whether selected landmark addresses
  should be returned (internal use only)}

  \item{ptsize}{Numeric Size to plot the mesh points
  (vertices), e.g. 0.1 for dense meshes, 3 for sparse
  meshes}

  \item{center}{Logical Whether the object 'spec' should be
  centered prior to digitizing (default {center=TRUE})}
}
\value{
Function writes to the working directory an NTS file with
the name of the specimen and .nts suffix containing the
landmark coordinates. If index=FALSE function returns to
the console an n x 3 matrix containing the x,y,z
coordinates of the digitized landmarks. If index=TRUE,
function returns a list: \item{selected}{a matrix
containing the x,y,z coordinates of the digitized
landmarks} \item{fix}{a matrix of addresses for landmarks
that are "fixed" (for internal use)}
}
\description{
An interactive function to digitize three-dimensional (3D)
landmarks. Input for the function is either a matrix of
vertex coordinates defining a 3D surface object or a mesh3d
object as obtained from \code{\link{read.ply}}.
}
\details{
Function for digitizing "n" three-dimensional landmarks.
The landmarks are "fixed" (traditional landmarks). They can
be later designated as "curve sliders" (semilandmarks, that
will "slide" along curves lacking known landmarks if
required. A sliding semi-landmark ("sliders") will slide
between two designated points, along a line tangent to the
specified curvature, and must be defined as "sliders" using
function \code{\link{define.sliders.3d}} or with similar
format matrix made outside R.

For 3D "surface sliders" (surface semilandmarks that slide
over a surface) the function \code{\link{digitsurface}}
should be used instead.  NOTE: Function centers the mesh
before digitizing by default (center=TRUE). If one chooses
not to center, specimen may be difficult to manipulate in
rgl window.

\subsection{Digitizing}{ Digitizing is interactive between
landmark selection using a mouse (see below for
instructions), and the R console. Once a point is selected,
the user is asked if the system should keep or discard the
selection #'(y/n). If "y", the user is asked to continue to
select the next landmark. If "n" the removes the last
chosen landmark, and the user is asked to select it again.
This can be repeated until the user is comfortable with the
landmark chosen.

To digitize with a standard 3-button (PC): \enumerate{
\item the RIGHT mouse button (primary) to select points to
be digitized (click-drag a box around a vertex to select as
landmark), \item the LEFT mouse button (secondary) is used
to rotate mesh, \item the mouse SCROLLER (third/middle) is
used to zoom in and out. } NOTE: Digitizing functions on
MACINTOSH computers using a standard 3-button mice works as
specified. Macs using platform specific single button mice,
XQuartz must be configured: go to Preferences > Input >
tick "Emulate three button mouse": \enumerate{ \item press
button to rotate 3D mesh, \item press button while pressing
COMMAND key to select points to be digitized (click-drag a
box around a vertex to select as landmark), \item press
button while pressing OPTION key to adjust mesh
perspective.  \item the mouse SCROLLER or trackpad two
finger scroll is used to zoom in an out.  }

NOTE: there is no pan (translate) functionality in rgl
library for all platforms at this time. }
}
\author{
Erik Otarola-Castillo & Emma Sherratt
}
\seealso{
\code{\link{read.ply}}
}
\keyword{digitizing}

