% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plotspec}
\alias{plotspec}
\title{Plot 3D specimen, fixed landmarks and surface semilandmarks.}
\usage{
plotspec(spec, digitspec, fixed = NULL, ptsize = 1, centered = FALSE, ...)
}
\arguments{
\item{spec}{An object of class shape3d/mesh3d, or matrix of 3D vertex coordinates.}

\item{digitspec}{Name of data matrix containing 3D fixed and/or surface sliding coordinates.}

\item{fixed}{Numeric The number of fixed template landmarks (listed first in {digitspec})}

\item{ptsize}{Numeric Size to plot the mesh points (vertices), e.g. 0.1 for dense meshes, 3 for sparse meshes}

\item{centered}{Logical Whether the data matrix is in the surface mesh coordinate system ({centered=FALSE}) or
if the data were collected after the mesh was centered ({centered=TRUE})- see details.}

\item{...}{additional parameters which will be passed to \code{\link{plot3d}}.}
}
\description{
A function to plot three-dimensional (3D) specimen along with its landmarks.
}
\details{
Function to plot 3D specimens along with their digitized "fixed" landmarks and semilandmarks
"surface sliders" and "curve sliders". If specimen is a 3D surface (class shape3d/mesh3d) mesh is plotted.
For visualization purposes, 3D coordinate data collected using \code{\link{digit.fixed}} or
\code{\link{digitsurface}} and \code{\link{buildtemplate}} prior to build 1.1-6 were centered by default.
Therefore use this function with {centered=TRUE}. Data collected outside geomorph should be read using
{centered=FALSE}. The function assumes the fixed landmarks are listed at the beginning of
the coordinate matrix ({digitspec}).
}
\examples{
data(scallopPLY)
ply <- scallopPLY$ply
digitdat <- scallopPLY$coords
plotspec(spec=ply,digitspec=digitdat,fixed=16, centered =TRUE)
}
\author{
Erik Otarola-Castillo & Emma Sherratt
}
\seealso{
\code{\link{warpRefMesh}}

\code{\link{read.ply}}
}
\keyword{visualization}

