% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotOutliers.r
\name{plotOutliers}
\alias{plotOutliers}
\title{Find potential outliers}
\usage{
plotOutliers(A, groups = NULL)
}
\arguments{
\item{A}{An array (p x k x n) containing GPA-aligned coordinates for a set of specimens}

\item{groups}{An optional factor defining groups}
}
\value{
Function returns the landmark addresses of all specimens ordered as in the plot. If groups are used, function returns
a list structure and a plot for each level in groups.
}
\description{
Function plots all specimens ordered by distance from the mean.
}
\details{
The function creates a plot of all specimens ordered by their Procrustes distance from the mean shape.
The median distance (unbroken line) and upper and lower quartiles (dashed lines) summarize the distances
from the mean shape. Specimens falling above the upper quartile are plotted in red. The addresses of all specimens are
returned in the order displayed in the plot for further inspection by \code{\link{plotRefToTarget}}.

If the data have strong group structure and there is reasonable belief that the whole sample mean should not be used,
then a factor defining the groups can be used.
}
\examples{
data(plethodon)
# let's make some outliers
newland <- plethodon$land
newland[c(1,8),,2] <- newland[c(8,1),,2]
newland[c(3,11),,26] <- newland[c(11,3),,2]
Y<- gpagen(newland) # GPA
out <- plotOutliers(Y$coords) # function returns dimnames and address of all specimens ordered
plotRefToTarget(mshape(Y$coords), Y$coords[,,out[1]], method="vector")
plotRefToTarget(mshape(Y$coords), Y$coords[,,out[2]], method="vector")
}
\author{
Emma Sherratt
}
\seealso{
\code{\link{gpagen}}

\code{\link{plotTangentSpace}}

\code{\link{plotAllSpecimens}}
}
\keyword{utilities}

