% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeHulls.r
\name{shapeHulls}
\alias{shapeHulls}
\title{Update Plots with Convex Hulls for Groups}
\usage{
shapeHulls(
  x,
  groups = NULL,
  group.cols = NULL,
  group.lwd = NULL,
  group.lty = NULL
)
}
\arguments{
\item{x}{A \code{\link{plot.procD.lm}} or \code{\link{plot.gm.prcomp}} plot object.}

\item{groups}{An optional vector or factor to define groups for hull.  If NULL, only one hull will be generated for all points.}

\item{group.cols}{An optional vector to define hull colors, arranged in the same order as factor levels.  If NULL and if multiple groups
exist, the general R color sequence (black, red, green, blue, etc.) will be used.}

\item{group.lwd}{An optional vector equal in length to the number of group levels, and arranged in the order of group levels,
to modify hull line width.}

\item{group.lty}{An optional vector equal in length to the number of group levels, and arranged in the order of group levels,
to modify hull line type.}
}
\description{
This function is used to update \code{\link{plot.procD.lm}} and \code{\link{plot.gm.prcomp}} ordination plot
objects with convex hulls for different groups.  If no groups are defined (groups is NULL) just a single
convex hull will be returned.  Groups do not need to be a factor in the original \code{\link{procD.lm}} fit.
}
\details{
This function is a wrapper for the \code{\link{points}} function. It is intentionally limited, so
as to not interfere with other plot parameter adjustments.
}
\examples{

# Via procD.lm and plot.procD.lm

data("pupfish")
gdf <- geomorph.data.frame(coords = pupfish$coords, Sex = pupfish$Sex,
Pop = pupfish$Pop)
fit <- procD.lm(coords ~ Pop * Sex, data = gdf, print.progress = FALSE)
pc.plot <- plot(fit, type = "PC", pch = 19)
shapeHulls(pc.plot)

pc.plot <- plot(fit, type = "PC", pch = 19)
groups <- interaction(gdf$Pop, gdf$Sex)

shapeHulls(pc.plot, groups = groups, 
group.cols = c("dark red", "dark red", "dark blue", "dark blue"),
group.lwd = rep(2, 4), group.lty = c(2, 1, 2, 1))

legend("topright", levels(groups), 
col = c("dark red", "dark red", "dark blue", "dark blue"),
lwd = rep(2,4), lty = c(2, 1, 2, 1))

pc.plot <- plot(fit, type = "PC", pch = 19)
shapeHulls(pc.plot, groups = gdf$Sex, group.cols = c("black", "black"), 
group.lwd = rep(2, 2), group.lty = c(2, 1))
legend("topright", levels(gdf$Sex), lwd = 2, lty = c(2, 1))

# Via gm.prcomp and plot.gm.prcomp

data(plethspecies) 
Y.gpa <- gpagen(plethspecies$land)    #GPA-alignment
pleth.phylo <- gm.prcomp(Y.gpa$coords, phy = plethspecies$phy)
summary(pleth.phylo)

pc.plot <- plot(pleth.phylo, phylo = TRUE)
gp <- factor(c(rep(1, 5), rep(2, 4)))
shapeHulls(pc.plot, groups = gp, group.cols = 1:2, 
group.lwd = rep(2, 2), group.lty = c(2, 1))
legend("topright", c("P. cinereus clade", "P. hubrichti clade"), 
col = 1:2, lwd = 2, lty = c(2, 1))
}
\seealso{
\code{\link{procD.lm}}
}
\author{
Michael Collyer
}
\keyword{utilities}
