% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomultistar.R
\name{geomultistar}
\alias{geomultistar}
\title{\code{geomultistar} S3 class}
\usage{
geomultistar(ms = NULL, geodimension = NULL)
}
\arguments{
\item{ms}{A \code{multistar} structure.}

\item{geodimension}{A vector of dimension names.}
}
\value{
A \code{geomultistar} object.
}
\description{
A \code{geomultistar} object is created. Dimensions that contain geographic
information are indicated.
}
\examples{
library(starschemar)

r <- ct_mrs |>
  constellation_as_multistar()

gms <- geomultistar(ms = r, geodimension = "where")

}
\seealso{
Other geo functions: 
\code{\link{define_geoattribute}()},
\code{\link{get_empty_geoinstances}()},
\code{\link{run_geoquery}()}
}
\concept{geo functions}
