% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-binary-atomic.R
\name{geos_disjoint}
\alias{geos_disjoint}
\alias{geos_touches}
\alias{geos_intersects}
\alias{geos_crosses}
\alias{geos_within}
\alias{geos_contains}
\alias{geos_overlaps}
\alias{geos_equals}
\alias{geos_equals_exact}
\alias{geos_covers}
\alias{geos_covered_by}
\alias{geos_prepared_disjoint}
\alias{geos_prepared_touches}
\alias{geos_prepared_intersects}
\alias{geos_prepared_crosses}
\alias{geos_prepared_within}
\alias{geos_prepared_contains}
\alias{geos_prepared_contains_properly}
\alias{geos_prepared_overlaps}
\alias{geos_prepared_covers}
\alias{geos_prepared_covered_by}
\title{Binary predicates}
\usage{
geos_disjoint(geom1, geom2)

geos_touches(geom1, geom2)

geos_intersects(geom1, geom2)

geos_crosses(geom1, geom2)

geos_within(geom1, geom2)

geos_contains(geom1, geom2)

geos_overlaps(geom1, geom2)

geos_equals(geom1, geom2)

geos_equals_exact(geom1, geom2, tolerance = .Machine$double.eps^2)

geos_covers(geom1, geom2)

geos_covered_by(geom1, geom2)

geos_prepared_disjoint(geom1, geom2)

geos_prepared_touches(geom1, geom2)

geos_prepared_intersects(geom1, geom2)

geos_prepared_crosses(geom1, geom2)

geos_prepared_within(geom1, geom2)

geos_prepared_contains(geom1, geom2)

geos_prepared_contains_properly(geom1, geom2)

geos_prepared_overlaps(geom1, geom2)

geos_prepared_covers(geom1, geom2)

geos_prepared_covered_by(geom1, geom2)
}
\arguments{
\item{geom1}{\link[=as_geos_geometry]{GEOS geometry vectors},
recycled to a common length.}

\item{geom2}{\link[=as_geos_geometry]{GEOS geometry vectors},
recycled to a common length.}

\item{tolerance}{The maximum separation of vertices that should
be considered equal.}
}
\value{
A logical vector along the recycled length of \code{geom1} and \code{geom2}
}
\description{
Binary predicates
}
