% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-core-utilities.R
\name{get_region_boundary}
\alias{get_region_boundary}
\title{Get region boundary for any specified region}
\usage{
get_region_boundary(region_def, verbose = FALSE)
}
\arguments{
\item{region_def}{Region definition in various formats:
\itemize{
\item Character: "Ohio", "Nigeria", "CONUS"
\item Character with colon: "Ohio:Franklin" (state:county)
\item Numeric vector: c(xmin, ymin, xmax, ymax) bounding box
\item sf object: existing spatial object
}}

\item{verbose}{Print progress messages}
}
\value{
sf object with boundary geometry
}
\description{
Universal function to get region boundaries for any geographic area including
US states, countries, CONUS, counties, or custom bounding boxes with
comprehensive error handling.
}
\examples{
\donttest{
# US State with error handling
ohio_boundary <- get_region_boundary("Ohio")

# Custom bounding box with validation
custom_area <- get_region_boundary(c(-84.5, 39.0, -82.0, 41.0))
}

}
