% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{make_EV}
\alias{make_EV}
\title{Extract eigenfunctions of a connectivity matrix for spatial filtering}
\source{
Daniel Griffith and Yongwan Chun. 2014. "Spatial Autocorrelation and Spatial Filtering." in M. M. Fischer and P. Nijkamp (eds.), \emph{Handbook of Regional Science.} Springer.
}
\usage{
make_EV(C, nsa = FALSE, threshold = 0.2, values = FALSE)
}
\arguments{
\item{C}{A binary spatial weights matrix. See \code{\link[geostan]{shape2mat}}.}

\item{nsa}{Logical. Default of \code{nsa = FALSE} excludes eigenvectors capturing negative spatial autocorrelation.
Setting \code{nsa = TRUE} will result in a candidate set of EVs that contains eigenvectors representing positive and negative SA.}

\item{threshold}{Defaults to \code{threshold=0.2} to exclude eigenvectors representing spatial autocorrelation levels that are less than \code{threshold} times the maximum possible Moran coefficient achievable for the given spatial connectivity matrix. If \code{theshold = 0}, all eigenvectors will be returned (however, the eigenvector of constants (with eigenvalue of zero) will be dropped automatically).}

\item{values}{Should eigenvalues be returned also? Defaults to \code{FALSE}.}
}
\value{
A \code{data.frame} of eigenvectors for spatial filtering. If \code{values=TRUE} then a named list is returned with elements \code{eigenvectors} and \code{eigenvalues}.
}
\description{
Extract eigenfunctions of a connectivity matrix for spatial filtering
}
\details{
Returns a set of eigenvectors related to the Moran coefficient (MC), limited to those eigenvectors with |MC| > \code{threshold} if \code{nsa = TRUE} or MC > \code{threshold} if \code{nsa = FALSE}, optionally with corresponding eigenvalues.
}
\examples{
library(ggplot2)
data(georgia)
C <- shape2mat(georgia, style = "B")
EV <- make_EV(C)
head(EV)

ggplot(georgia) +
  geom_sf(aes(fill = EV[,1])) +
  scale_fill_gradient2()
}
\seealso{
\link[geostan]{stan_esf}, \link[geostan]{mc}
}
