% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcRandKmap.R
\name{genData}
\alias{genData}
\title{generate data}
\usage{
genData(DataObj = NULL, seed = 0, nPoints = 450, typeMod = "Exp",
  Vpsill = 5, Vrange = 0.2, Vmean = 8, Vnugget = 0, Vanis = 1,
  boundary = list(x = c(0, 0, 1, 1, 0), y = c(0, 1, 1, 0, 0)),
  manualBoundary = FALSE)
}
\arguments{
\item{DataObj}{=NULL: simulated data with given seed or a data frame with real data}

\item{seed}{numeric value used to generate simulated data}

\item{nPoints}{number of generated raw data points}

\item{typeMod}{type of variogram model (see vgm) "Gau", "Sph", "Exp"}

\item{Vpsill}{partial sill in variogram}

\item{Vrange}{variogram range}

\item{Vmean}{average data value}

\item{Vnugget}{nugget in variogram}

\item{Vanis}{anisotropy in variogram}

\item{boundary}{list, contains x and y boundaries}

\item{manualBoundary}{logical, if TRUE a manual boundary is drawn.}
}
\value{
a list
\describe{
\item{tabData}{data frame of generated or real data with x,y,z values. x is standardized between 0 and 1, y is standardized with the same ratio used for x }
\item{boundary}{standardized boundary}
\item{VGMmodel}{VGM variogram model}
\item{modelGen}{RM transformed variogram model}
\item{ratio}{ratio used to normalize x data}
}
}
\description{
generate data
}
\details{
description, a paragraph
}
\examples{
# simulate data with Gaussian model
resGene=genData(NULL,10,450,"Gau",5,0.2,8,0,list(x=c(0,0,1,1,0),y=c(0,1,1,0,0)),FALSE)
plot(resGene$tabData)
}
