% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothingZone.R
\name{touch.border}
\alias{touch.border}
\title{touch.border}
\usage{
touch.border(z, boundary)
}
\arguments{
\item{z}{a zone (SpatialPolygon)}

\item{boundary}{union of all zones of the corrected map (result of correctBoundaryMap())}
}
\value{
logical, TRUE if zone has a commun boundary with the map, FALSE otherwise
}
\description{
touch.border
}
\details{
verify if a zone has a commun boundary with the map
}
\examples{
map = geozoning::mapTest
criti = correctionTree(qProb = c(0.5), map = map)
Z = criti$zk[[1]][[1]]$zonePolygone
lab = criti$zk[[1]][[1]]$lab
# zone correction
res = correctBoundaryMap(Zi = Z, map = map)
Z = res$Z
# map boundary after correction
boundary = Z[[1]]
for(i in 2:length(Z)){
  boundary = rgeos::gUnion(boundary, Z[[i]])
}
# plot map
plotM(map = map, Z = Z, lab = lab, byLab = FALSE)
# verification
for(i in 1:length(Z)){
  print(touch.border(z = Z[[i]], boundary = boundary))
}
}
