#' Function that reads the database of links and access dates of articles
#'
#' The basede_linkdate function reads a csv file containing the links and access dates of scientific articles, selected and represented by the sequence present in the position_artic parameter. The function returns a dataframe that will be used by the gerefer package.
#'
#' @param path_date is a directory path containing the csv file
#'
#'
#' @importFrom utils read.csv2
#' @return The function returns a table containing the links and access dates of the chosen scientific articles.
#' @export
#'
#' @references
#' Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier
#'
#' @examples
#'
#' #Call the function of links and access data
#'
#' file_base <- system.file("extdata","tabarticle_example1.csv", package = "gerefer")
#' dateacess_link <- basede_linkdate(file_base)
#' dateacess_link
#'
#'
basede_linkdate <- function(path_date){

  date_package <- read.csv2(path_date)

  return(date_package)
}
