% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_prediction.R
\name{fit_KM}
\alias{fit_KM}
\title{Fit Weibull and Log-Normal survival curves to Kaplan Meier estimates}
\usage{
fit_KM(KMcurve, Survival = "Survival", Time = "Time",
  type = c("automatic", "Weibull", "Lognormal"), weighting = TRUE,
  Weights = "Weights", Weight_power = 1, startbeta = 1,
  startsigma = 1)
}
\arguments{
\item{KMcurve}{The dataframe object containing the survival data in lifetable form}

\item{Survival}{The column name for the survival function (i.e. the probabilities). Default is "Survival"}

\item{Time}{The column name for the times. Default is "Time"}

\item{type}{Type of event curve to fit.Default is "Automatic", fitting both Weibull and Log-normal curves.
Alternatively accepts "Weibull" or "Lognormal" to force the type.}

\item{weighting}{Boolean for whether to use weighting. Default=TRUE as it greatly improves curve fitting.}

\item{Weights}{Name of Weights column. Default="Weights". Optional if weighting=FALSE. Recommended to use number at risk or remaining.}

\item{Weight_power}{Power to raise the weights to. Useful in large trials to give added weight to later points where numbers may still be high. Default=1 (Use weights as specified)}

\item{startbeta}{Starting value for the Weibull beta (shape) parameter to be used in the non-linear regression. Default=1 (exponential).}

\item{startsigma}{Starting value for the Lognormal sigma (sd) parameter to be used in the non-linear regression. Default=1.}
}
\value{
Returns a 3-item list providing information needed to define a Curve object:
\itemize{
 \item{"Item 1"}{The type of Curve object fitted.}
 \item{"Item 2"}{A list of fitted parameters for the curve type.}
 \item{"Item 3"}{A vector containing the covariance-matrix parameters for the curve type. Note that these are heavily underestimated as the data going into the regression is not independent.}
 \item{"Item 4"}{A data frame containing the goodness of fit metrics for each curve type.}
}
}
\description{
This is a function to fit Weibull and log-normal curves to Survival data in life-table form using non-linear regression.\cr
By default it fits both, then picks the best fit based on the lowest (un)weighted residual sum of squares.\cr
Alternatively, just one shape may be fitted, by changing the 'type' argument to either "Weibull" or "Lognormal".
Weighted or unweighted fitting are possible. In general, weighted fitting using the number at risk as the weights seems to work best.\cr
This function is primarily used by event_prediction function, but also useful for general KM curve fitting.\cr
One useful aspect of this is for fitting the 'inverse KM', where drop-outs are events, while events and 'time-outs' are censored.
   This allows for finding a suitable parameterisation for the censoring curve.\cr
Primary advantage over likelihood-based methods is ability to use aggregated, rather than patient-level data.
Primary disadvantage is that the covariance matrix is heavily underestimated (essentially unusable) due to strong correlation between the input data points going into the regression.
}
\examples{
recruit <- PieceR(matrix(c(rep(1,12),10,15,25,30,45,60,55,50,65,60,55,30),ncol=2),1)
example_data_short <- simulate_trials(active_ecurve=Weibull(50,0.8),
control_ecurve=Weibull(50,0.8), rcurve=recruit,assess=10,iterations=1,seed=12345,
detailed_output=TRUE)

library(survival)

temp1  <- summary(survfit(Surv(example_data_short[,"Time"],1-example_data_short[,"Censored"])~ 1,
error="greenwood"))
out1 <- cbind(temp1$time,temp1$n.risk,temp1$surv,temp1$std.err)
out1 <- rbind(c(0,out1[1,2],1,0),out1)
colnames(out1) <- c("Time","NAR","Survival","Std.Err")
x1 <- ceiling(max(out1[,"Time"]))
example_lifetable <- out1[findInterval(0:x1,out1[,"Time"]),]
example_lifetable[,"Time"] <- 0:x1

fit_KM(KMcurve=example_lifetable,Survival="Survival",Time="Time",Weights="NAR",type="automatic")
}
\author{
James Bell
}
