% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debug.R
\name{debug_traceTransaction}
\alias{debug_traceTransaction}
\title{Transaction tracing.}
\usage{
debug_traceTransaction(hash, disableStorage = NULL,
  disableMemory = NULL, disableStack = NULL, tracer = NULL,
  timeout = NULL)
}
\arguments{
\item{hash}{Data - Hash of the transaction.}

\item{disableStorage}{Boolean - Setting this to \code{true} will disable
storage capture (default = \code{false}).}

\item{disableMemory}{Boolean - Setting this to \code{true} will disable
memory capture (default = \code{false})}

\item{disableStack}{Boolean - Setting this to \code{true} will disable stack
capture (default = \code{false})}

\item{tracer}{String - Setting this will enable JavaScript-based transaction
tracing. If set, the previous arguments will be ignored.}

\item{timeout}{String -  Overrides the default timeout of 5 seconds for
JavaScript-based tracing calls.}
}
\value{
Object - Full trace of the transaction.
}
\description{
\code{debug_traceTransaction} attempts to run the transaction in the exact
same manner as it was executed on the network. It will replay any transaction
that may have been executed prior to this one before it will finally attempt
to execute the transaction that corresponds to the given hash.
}
\examples{
\donttest{
debug_traceTransaction('0xe45f738135240ce9cedc58b21148ef424704e5c86798990a5
a36cb1ca4c5c3f4')
debug_traceTransaction('0xe45f738135240ce9cedc58b21148ef424704e5c86798990a5
a36cb1ca4c5c3f4', disableStorage = TRUE, disableStack = TRUE)
}

}
\seealso{
Other debug functions: \code{\link{debug_backtraceAt}},
  \code{\link{debug_blockProfile}},
  \code{\link{debug_cpuProfile}},
  \code{\link{debug_dumpBlock}},
  \code{\link{debug_gcStats}},
  \code{\link{debug_getBlockRlp}},
  \code{\link{debug_goTrace}},
  \code{\link{debug_memStats}},
  \code{\link{debug_seedHash}},
  \code{\link{debug_setBlockProfileRate}},
  \code{\link{debug_setHead}}, \code{\link{debug_stacks}},
  \code{\link{debug_startCPUProfile}},
  \code{\link{debug_startGoTrace}},
  \code{\link{debug_stopCPUProfile}},
  \code{\link{debug_stopGoTrace}},
  \code{\link{debug_traceBlockByHash}},
  \code{\link{debug_traceBlockByNumber}},
  \code{\link{debug_traceBlockFromFile}},
  \code{\link{debug_traceBlock}},
  \code{\link{debug_verbosity}},
  \code{\link{debug_vmodule}},
  \code{\link{debug_writeBlockProfile}},
  \code{\link{debug_writeMemProfile}}, \code{\link{gethr}}
}
\concept{debug functions}
