% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eth.R
\name{eth_getUncleByBlockNumberAndIndex}
\alias{eth_getUncleByBlockNumberAndIndex}
\title{Uncle information given a block number and an index position.}
\usage{
eth_getUncleByBlockNumberAndIndex(block_number, uncle_index, hex = TRUE)
}
\arguments{
\item{block_number}{Integer|Tag - Block number, or the string 'earliest',
'latest' or 'pending'.}

\item{uncle_index}{Integer - Uncle index position.}

\item{hex}{Boolean - \code{true} to get the response in hexadecimal,
\code{false} to get a readable response.}
}
\value{
Object - A block object, or \cite{null} when no block was found.
}
\description{
\code{eth_getUncleByBlockHashAndIndex} returns information about a uncle of a
block by number and uncle index position.
}
\examples{
\donttest{
eth_getUncleByBlockNumberAndIndex(42364, 345)
}

}
\seealso{
Other eth functions: \code{\link{eth_accounts}},
  \code{\link{eth_blockNumber}}, \code{\link{eth_call}},
  \code{\link{eth_coinbase}},
  \code{\link{eth_estimateGas}},
  \code{\link{eth_gasPrice}}, \code{\link{eth_getBalance}},
  \code{\link{eth_getBlockByHash}},
  \code{\link{eth_getBlockByNumber}},
  \code{\link{eth_getBlockTransactionCountByHash}},
  \code{\link{eth_getBlockTransactionCountByNumber}},
  \code{\link{eth_getCode}},
  \code{\link{eth_getFilterChanges}},
  \code{\link{eth_getFilterLogs}},
  \code{\link{eth_getLogs}}, \code{\link{eth_getProof}},
  \code{\link{eth_getStorageAt}},
  \code{\link{eth_getTransactionByBlockHashAndIndex}},
  \code{\link{eth_getTransactionByBlockNumberAndIndex}},
  \code{\link{eth_getTransactionByHash}},
  \code{\link{eth_getTransactionCount}},
  \code{\link{eth_getTransactionReceipt}},
  \code{\link{eth_getUncleByBlockHashAndIndex}},
  \code{\link{eth_getUncleCountByBlockHash}},
  \code{\link{eth_getUncleCountByBlockNumber}},
  \code{\link{eth_getWork}}, \code{\link{eth_hashrate}},
  \code{\link{eth_mining}},
  \code{\link{eth_newBlockFilter}},
  \code{\link{eth_newFilter}},
  \code{\link{eth_newPendingTransactionFilter}},
  \code{\link{eth_protocolVersion}},
  \code{\link{eth_sendRawTransaction}},
  \code{\link{eth_sendTransaction}},
  \code{\link{eth_sign}}, \code{\link{eth_submitHashrate}},
  \code{\link{eth_submitWork}}, \code{\link{eth_syncing}},
  \code{\link{eth_uninstallFilter}}, \code{\link{gethr}},
  \code{\link{personal_sendTransaction}}
}
\concept{eth functions}
