% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{gfiSummary}
\alias{gfiSummary}
\title{Summary of fiducial distributions}
\usage{
gfiSummary(gfi, conf = 0.95)
}
\arguments{
\item{gfi}{a \code{gfilmm} object (output of \code{\link{gfilmm}} or 
\code{\link{gfilmmPredictive}})}

\item{conf}{confidence level}
}
\value{
A matrix with summary statistics: means, medians, confidence 
  intervals, and probabilities that the standard deviations equal 0.
}
\description{
Summary of fiducial distributions
}
\examples{
data(KM41)
h <- 0.005
gfi <- gfilmm(~ cbind(y-h, y+h), ~ 1, ~ Batch, data = KM41, N = 5000)
gfiSummary(gfi)
}
