% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{gfiCDF}
\alias{gfiCDF}
\title{Fiducial cumulative distribution function}
\usage{
gfiCDF(parameter, gfi)
}
\arguments{
\item{parameter}{a right-sided formula defining the parameter of interest, 
like \code{~ sigma_error/`(Intercept)`}}

\item{gfi}{a \code{gfilmm} object (output of \code{\link{gfilmm}} or 
\code{\link{gfilmmPredictive}})}
}
\value{
The fiducial cumulative distribution function of the parameter.
}
\description{
Fiducial cumulative distribution function of a parameter of 
  interest.
}
\examples{
h <- 0.01
gfi <- gfilmm(
  ~ cbind(yield-h, yield+h), ~ 1, ~ block, data = npk, N = 5000, nthreads = 2
)
F <- gfiCDF(~ sqrt(sigma_block^2 + sigma_error^2)/`(Intercept)`, gfi)
plot(F, xlim = c(0, 0.3), main = "Coefficient of variation", 
     ylab = expression("Pr("<="x)"))
F(0.2)
}
