% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{gfiSummary}
\alias{gfiSummary}
\title{Summary of fiducial samples}
\usage{
gfiSummary(fidsamples, conf = 0.95)
}
\arguments{
\item{fidsamples}{fiducial samples, the output of \code{\link{gfilogisreg}}}

\item{conf}{confidence level}
}
\value{
A matrix with summary statistics: means, medians, and confidence
  intervals.
}
\description{
Summary of the fiducial samples.
}
\examples{
y <- c(0, 0, 1, 1, 1)
x <- c(-2, -1, 0, 1, 2)
fidsamples <- gfilogisreg(y ~ x, N = 400) # (N=400 is not serious)
gfiSummary(fidsamples)
}
