% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ggMarginal.R
\name{ggMarginal}
\alias{ggMarginal}
\title{Add marginal density/histogram to ggplot2 scatterplots}
\usage{
ggMarginal(p, data, x, y, type = "density", margins = "both", size = 5,
  marginCol = "black", marginFill = "grey")
}
\arguments{
\item{p}{A ggplot2 scatterplot to add marginal plots to.  If \code{p} is
not provided, then all of \code{data}, \code{x}, and \code{y} must be
provided.}

\item{data}{The data.frame to use for creating the marginal plots. Optional
if \code{p} is provided and the marginal plots are reflecting the same data.}

\item{x}{The name of the variable along the x axis. Optional if \code{p} is
provided and the \code{x} aesthetic is set in the main plot.}

\item{y}{The name of the variable along the y axis. Optional if \code{p} is
provided and the \code{y} aesthetic is set in the main plot.}

\item{type}{What type of marginal plot to show. One of: [density, histogram].}

\item{margins}{Along Which margins to show the plots. One of: [both, x, y].}

\item{size}{Integer describing the relative size of the marginal plots
compared to the main plot. A size of 5 means that the main plot is 5x wider
and 5x taller than the marginal plots.}

\item{marginCol}{The colour to use for the outline of the marginal
density/histogram.}

\item{marginFill}{The colour to use for the fill of the marginal histogram
(not used when \code{type} is "density")}
}
\value{
An object of class ggExtraPlot. This extra class gets added onto
a ggplot2 object in order for the \code{print} generic to easily work with
this object. This means that the return value from this function can be
printed or saved for later.
}
\description{
Create a ggplot2 scatterplot with marginal density plots (default) or
histograms, or add the marginal plots to an existing scatterplot.
}
\note{
The \code{grid} and \code{gridExtra} packages are required for this
function.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  if (requireNamespace("gridExtra", quietly = TRUE)) {
    if (requireNamespace("grid", quietly = TRUE)) {
      p <- ggplot2::ggplot(mtcars, ggplot2::aes(wt, mpg)) + ggplot2::geom_point()
      ggMarginal(p)

      set.seed(30)
      df <- data.frame(x = rnorm(500, 50, 10), y = runif(500, 0, 50))
      p2 <- ggplot2::ggplot(df, ggplot2::aes(x, y)) + ggplot2::geom_point()
      ggMarginal(p2)
      ggMarginal(p2, type = "histogram")
      ggMarginal(p2, margins = "x")
      ggMarginal(p2, size = 2)
      p2 <- p2 + ggplot2::ggtitle("Random data") + ggplot2::theme_bw(30)
      ggMarginal(p2)

      ggMarginal(data = df, x = "x", y = "y")

      set.seed(30)
      df2 <- data.frame(x = c(rnorm(250, 50, 10), rnorm(250, 100, 10)),
                        y = runif(500, 0, 50))
      p3 <- ggplot2::ggplot(df2, ggplot2::aes(x, y)) + ggplot2::geom_point()
      ggMarginal(p3)
    }
  }
}
}

