% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx-plots-eta-cov.R
\name{eta_cov_plot}
\alias{eta_cov_plot}
\alias{dummy}
\alias{pmx_plot_eta_cats}
\alias{pmx_plot_eta_conts}
\title{Eta Covariates plots}
\usage{
dummy(dname, show.correl, correl, point, facets, filter, strat.facet,
  strat.color, trans, pmxgpar, labels, axis.title, axis.text, ranges,
  is.smooth, smooth, is.band, band, is.draft, draft, is.identity_line,
  identity_line, scale_x_log10, scale_y_log10, color.scales)

pmx_plot_eta_cats(ctr, ...)

pmx_plot_eta_conts(ctr, ...)
}
\arguments{
\item{dname}{\code{character} name of dataset to be used}

\item{show.correl}{\code{logical} if TRUE add correlation to the plot}

\item{correl}{\code{list} correl geom text graphical parameter}

\item{point}{\code{list} geom point graphical parameter}

\item{facets}{\code{list} facetting graphical parameter

\strong{pmx_update parameters}}

\item{filter}{\code{expression} filter which will be applied to plotting data.}

\item{strat.facet}{\code{formula} optional stratification parameter by facetting.
This split plot by strats(each strat in a facet)}

\item{strat.color}{\code{character} optional stratification parameter by grouping.
This will split the plot by group (color) of strat.}

\item{trans}{\code{character} define the transformation to apply on x or y or both variables}

\item{pmxgpar}{a object of class pmx_gpar possibly the output of the

\strong{pmx_gpar: Shared basic graphics parameters}}

\item{labels}{\code{list} list containing plot and/or axis labels: title, subtitle, x , y}

\item{axis.title}{\code{list} containing element_text attributes to customize
the axis title. (similar to ggplot2 axis.title theme)}

\item{axis.text}{\code{list} containing element_text attributes to customize
the axis text (similar to ggplot2 axis.text theme)}

\item{ranges}{\code{list} limits of x/y ranges}

\item{is.smooth}{\code{logical} if set to TRUE add smooth layer}

\item{smooth}{\code{list} geom_smooth graphical/smoothing fun parameters}

\item{is.band}{\code{logical} if TRUE add horizontal band}

\item{band}{\code{list} horizontal band parameters. geom_hline graphical parameters.}

\item{is.draft}{\code{logical} if TRUE add draft layer}

\item{draft}{\code{list} draft layer parameters. geom_text graphical parameters.}

\item{is.identity_line}{\code{logical} if TRUE add an identity line}

\item{identity_line}{\code{list}geom_abline graphical parameters.}

\item{scale_x_log10}{\code{logical} if TRUE use log10 scale for x axis.}

\item{scale_y_log10}{\code{logical} if TRUE use log10 scale for y axis.}

\item{color.scales}{\code{list} define scales parameter in case of strat.color \code{\link{pmx_settings}}}

\item{ctr}{pmx controller}

\item{...}{others graphics parameters passed :
\itemize{
\item \code{\link{pmx_gpar}} internal function to customize shared graphical parameters
\item \code{\link{eta_cov}} generic object for eta/covariates plots.
\item \code{\link{pmx_update}} function.
}

\strong{eta_cov parameters}}
}
\value{
ggplot2 object
}
\description{
Eta Covariates plots

Relationships between (ETA) and categorical covariates

Relationships between (ETA) and continuous covariates
}
\examples{


\donttest{
# basic use  ---------------------------------------

ctr <- theophylline()
ctr \%>\% pmx_plot_eta_cats
ctr \%>\% pmx_plot_eta_conts

# update graphical parameter  ----------------------

## update labels
ctr \%>\% pmx_plot_eta_cats(
  labels = list(title = "New eta cats title")
)

## remove draft
ctr \%>\% pmx_plot_eta_cats(is.draft = FALSE)

## change text color line
ctr \%>\% pmx_plot_eta_conts(
  correl=list(colour="magenta")
  )

## set covariates custom labels 

ctr \%>\% pmx_plot_eta_conts(
  covariates=pmx_cov(values=list("WT0","AGE0"),
                     labels=list("Weight","Age"))
)

## set effects and covaraites custom labels


ctr <- theophylline( settings = pmx_settings(
  effects=list( levels=c("ka", "V", "Cl"), 
                labels=c("Concentration","Volume","Clearance")
  )
)
)
ctr \%>\% pmx_plot_eta_conts(
  covariates=pmx_cov(values=list("WT0","AGE0"),
                     labels=list("Weight","Age"))
)

}



}
\concept{eta_cov_plot}
