% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-qq.R
\name{pmx_qq}
\alias{pmx_qq}
\title{This function creates a qq plot object}
\usage{
pmx_qq(
  x,
  labels,
  dname = NULL,
  point = NULL,
  xmax = TRUE,
  facets = NULL,
  is.reference_line = NULL,
  reference_line = NULL,
  is.shrink = NULL,
  shrink = NULL,
  is.hline = NULL,
  hline = NULL,
  is.vline = NULL,
  vline = NULL,
  ...
)
}
\arguments{
\item{x}{\code{character} variable name to sample}

\item{labels}{list of texts/titles used within the plot}

\item{dname}{name of dataset to be used}

\item{point}{\code{list} geom_point attributes color, shape,...}

\item{xmax}{\code{logical} if FALSE do not use max(aes(x)) as limits default to TRUE}

\item{facets}{\code{list}}

\item{is.reference_line}{\code{logical} if TRUE add reference line to the plot}

\item{reference_line}{\code{list} geom_line attributes. Used only for pmx_plot_eta_qq}

\item{is.shrink}{\code{logical} if TRUE add shrinkage to the plot}

\item{shrink}{\code{pmxShrinkClass} shrinkage graphical parameter or
\code{list} coercible into one}

\item{is.hline}{logical if TRUE add horizontal line y=0 ( TRUE by default)}

\item{hline}{geom hline graphical parameters}

\item{is.vline}{logical if TRUE add vertical line x=0 ( TRUE by default)}

\item{vline}{geom vline graphical parameters}

\item{...}{others graphics arguments passed to \code{\link{pmx_gpar}} internal object.}
}
\value{
\code{pmx_qq} object
}
\description{
This function creates a qq plot object
}
\details{
\strong{labels} is a list that contains:
\itemize{
\item {\strong{title:}} {plot title default  "EBE vs. covariates"}
\item {\strong{x:}} {x axis label default to "Etas"}
\item {\strong{y:}} {y axis label default to empty}
}

\strong{point} is a list that contains:
\itemize{
\item {\strong{shape:}} {default to 1}
\item {\strong{color:}} {default to black}
\item {\strong{size:}} {default to 1}
}
}
\concept{qq_plot}
